<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Admin_Controller
 */
class Admin_Controller extends User_Controller
{
    /**
     * Admin_Controller constructor.
     * @param int $userTypeId
     */
    public function __construct($userTypeId)
    {
        // Load the URL helper if not already loaded
        $this->load->helper('url');

        // Check if a user session exists
        if (!$this->session->userdata('user_id')) {
            redirect('sessions/login'); // Redirect to the login page
        }

        parent::__construct('user_type', $userTypeId);
    }
}

