<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Invoice_Custom
 */
class Mdl_Invoice_Custom extends Validator
{
    public static $positions = array(
        'custom_fields',
        'properties'
    );
    public $table = 'pd_invoice_custom';
    public $primary_key = 'pd_invoice_custom.invoice_custom_id';

    public function default_select()
    {
        $this->db->select('SQL_CALC_FOUND_ROWS pd_invoice_custom.*, pd_custom_fields.*', false);
    }

    public function default_join()
    {
        $this->db->join('pd_custom_fields', 'pd_invoice_custom.invoice_custom_fieldid = pd_custom_fields.custom_field_id');
    }

    public function default_order_by()
    {
        $this->db->order_by('custom_field_table ASC, custom_field_order ASC, custom_field_label ASC');
    }

    public function save_custom($invoice_id, $db_array)
    {
        $result = $this->validate($db_array);
        if ($result === true) {
            $form_data = isset($this->_formdata) ? $this->_formdata : null;

            if (is_null($form_data)) {
                return true;
            }

            $invoice_custom_id = null;

            foreach ($form_data as $key => $value) {
                $db_array = array(
                    'invoice_id' => $invoice_id,
                    'invoice_custom_fieldid' => $key,
                    'invoice_custom_fieldvalue' => $value
                );
                $invoice_custom = $this->where('invoice_id', $invoice_id)->where('invoice_custom_fieldid', $key)->get();

                if ($invoice_custom->num_rows()) {
                    $invoice_custom_id = $invoice_custom->row()->invoice_custom_id;
                }

                parent::save($invoice_custom_id, $db_array);
            }

            return true;
        }

        return $result;
    }

    public function by_id($invoice_id)
    {
        $this->db->where('pd_invoice_custom.invoice_id', $invoice_id);
        return $this;
    }

}
