<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Ajax
 */
class Ajax extends Admin_Controller
{
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);
    }
    public $ajax_controller = true;


    public function save()
{
    $this->load->model('expenses/mdl_expense_items');
    $this->load->model('expenses/mdl_expenses');
    $this->load->library('form_validation');
    $this->load->helper('date');

    // Set validation rules
    $this->form_validation->set_rules('expense_name', 'Expense Name', 'required');
    $this->form_validation->set_rules('expense_date_created', 'Expense Date', 'required');
    $this->form_validation->set_rules('expense_status', 'Expense Status', 'required');
    $this->form_validation->set_rules('items', 'Items', 'required');

    if ($this->form_validation->run() == FALSE) {
        $response['success'] = 0;
        $response['validation_errors'] = $this->form_validation->error_array();
        echo json_encode($response);
        return;
    }

    $expense_data = array(
        'expense_name' => $this->input->post('expense_name'),
        'expense_date_created' => $this->input->post('expense_date_created'),
        'expense_status' => $this->input->post('expense_status'),
        'user_id' => $this->session->userdata('user_id')
    );

    $expense_id = $this->mdl_expenses->insert_expense($expense_data);

    if ($expense_id) {
        // Get the ID of the last inserted record
        $last_insert_id = $this->db->insert_id();
    }

    // Decode the JSON-encoded items data from the POST request
$items = json_decode($this->input->post('items'), true);

// Loop through each item in the array and insert it into the 'pd_expense_items' table
foreach ($items as $item) {
    // Convert quantity and price to numerical values

    $item_quantity = floatval(str_replace(',','',$item['item_quantity'])) ;
    $item_price = floatval(str_replace(',','',$item['item_price'])) ;



    // Calculate the item total
    $item_total = $item_quantity * $item_price;

    // Create an array with the item data to be inserted into the table
    $item_data = array(
        'expense_id' => $last_insert_id,
        'item_bill_id' => $item['item_bill_id'],
        'item_name' => $item['item_name'],
        'item_description' => $item['item_description'],
        'item_price' => $item_price,
        'item_quantity' => $item_quantity,
        'item_total' => $item_total
    );

    // Insert the item data into the 'pd_expense_items' table
    $this->db->insert('pd_expense_items', $item_data);





}



    $response = [
        'success' => 1,
        'price' => $item_price,
        'quantity' => $item_quantity,
        'expense_id' => $last_insert_id,

    ];
    echo json_encode($response);
}


 /**
     * @param null $id
     *
     */


public function update($id = null)
{
    $this->load->model('expenses/mdl_expense_items');
    $this->load->model('expenses/mdl_expenses');
    $this->load->library('form_validation');
    $this->load->helper('date');

    // Set validation rules
    $this->form_validation->set_rules('expense_name', 'Expense Name', 'required');
    $this->form_validation->set_rules('expense_date_created', 'Expense Date', 'required');
    $this->form_validation->set_rules('expense_status', 'Expense Status', 'required');
    $this->form_validation->set_rules('items', 'Items', 'required');

    if ($this->form_validation->run() == FALSE) {
        $response['success'] = 0;
        $response['validation_errors'] = $this->form_validation->error_array();
        echo json_encode($response);
        return;
    }

    $expense_data = array(
        'expense_name' => $this->input->post('expense_name'),
        'expense_date_created' => $this->input->post('expense_date_created'),
        'expense_status' => $this->input->post('expense_status'),
        'user_id' => $this->session->userdata('user_id')
    );


    $expenses = $this->mdl_expenses->update_expense($id,$expense_data);


    // Decode the JSON-encoded items data from the POST request
$items = json_decode($this->input->post('items'), true);

// Loop through each item in the array and insert it into the 'pd_expense_items' table
foreach ($items as $item) {
    // Convert quantity and price to numerical values
    $item_quantity = floatval(str_replace(',','',$item['item_quantity'])) ;
    $item_price = floatval(str_replace(',','',$item['item_price'])) ;

    // Calculate the item total
    $item_total = $item_quantity * $item_price;

    // Create an array with the item data to be inserted into the table
    $item_data = array(
        'expense_id' => $id,
        'item_id' => $item['item_id'],
        'item_bill_id' => $item['item_bill_id'],
        'item_name' => $item['item_name'],
        'item_description' => $item['item_description'],
        'item_price' => $item_price,
        'item_quantity' => $item_quantity,
        'item_total' => $item_total
    );




    // Insert the item data into the 'pd_expense_items' table
    $items = $this->mdl_expense_items->update_items($id, $item_data);

    // $item_amount = $this->mdl_expense_items->insert_item_amounts();

    if($items && $expenses){
        $response = [
            'success' => 1,
            'price' => $item_price,
            'quantity' => $item_quantity,

        ];
    } else{

        $response = [
            'success' => 1,
            'price' => $item_price,
            'quantity' => $item_quantity,

        ];
    }



}




    echo json_encode($response);
}

public function delete_item(){



    $item_id = $this->input->post('item_id');

        $this->db->where('item_id', $item_id);
        $this->db->delete('pd_expense_items');

        // Check if the deletion was successful
        if ($this->db->affected_rows() > 0) {
            $response = [
                'success' => 1,

            ]; // Deletion successful
        } else {
            $response = [
                'success' => 0,

            ]; // Deletion failed
        }



    echo json_encode($response);

}

public function delete_expense(){



    $expense_id = $this->input->post('expense_id');

        $this->db->where('expense_id', $expense_id);
        $this->db->delete('pd_expense_items');

        $this->db->where('expense_id', $expense_id);
        $this->db->delete('pd_expenses');

        // Check if the deletion was successful
        if ($this->db->affected_rows() > 0) {
            $response = [
                'success' => 1,

            ]; // Deletion successful
        } else {
            $response = [
                'success' => 0,

            ]; // Deletion failed
        }



    echo json_encode($response);

}

public function modal_bills_lookups()
{
    $filter_bill = $this->input->get('filter_bill');
    $filter_family = $this->input->get('filter_family');
    $reset_table = $this->input->get('reset_table');

    $this->load->model('mdl_bills');
    $this->load->model('families/mdl_families');

    if (!empty($filter_family)) {
        $this->mdl_bills->by_family($filter_family);
    }

    if (!empty($filter_product)) {
        $this->mdl_bills->by_bill($filter_bill);
    }

    $bills = $this->mdl_bills->get()->result();
    $families = $this->mdl_families->get()->result();



    $data = array(
        'bills' => $bills,
        'families' => $families,
        'filter_bill' => $filter_bill,
        'filter_family' => $filter_family
    );

    if ($filter_bill || $filter_family || $reset_table) {
        $this->layout->load_view('expenses/partial_bills_table_modal', $data);
    } else {
        $this->layout->load_view('expenses/modal_bills_lookups', $data);
    }
}

public function process_bill_selections()
{
    $this->load->model('mdl_bills');

    $bills= $this->mdl_bills->where_in('bill_id', $this->input->post('bill_ids'))->get()->result();

    foreach ($bills as $bill) {
        $bill->bill_amount = format_amount($bill->bill_amount);
    }

    echo json_encode($bills);
}

}
