<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */
/**
 * Class Mdl_Quote_Tax_Rates
 */
class Mdl_Quote_Tax_Rates extends Response_Model
{
    public $table = 'pd_quote_tax_rates';
    public $primary_key = 'pd_quote_tax_rates.quote_tax_rate_id';

    public function default_select()
    {
        $this->db->select('pd_tax_rates.tax_rate_name AS quote_tax_rate_name');
        $this->db->select('pd_tax_rates.tax_rate_percent AS quote_tax_rate_percent');
        $this->db->select('pd_quote_tax_rates.*');
    }

    public function default_join()
    {
        $this->db->join('pd_tax_rates', 'pd_tax_rates.tax_rate_id = pd_quote_tax_rates.tax_rate_id');
    }

    /**
     * @param null $id
     * @param null $db_array
     * @return void
     */
    public function save($id = null, $db_array = null)
    {
        parent::save($id, $db_array);

        $this->load->model('quotes/mdl_quote_amounts');

        $quote_id = $this->input->post('quote_id');

        if ($quote_id) {
            $this->mdl_quote_amounts->calculate($quote_id);
        }
    }

    /**
     * @return array
     * @return void
     */
    public function validation_rules()
    {
        return array(
            'quote_id' => array(
                'field' => 'quote_id',
                'label' => trans('quote'),
                'rules' => 'required'
            ),
            'tax_rate_id' => array(
                'field' => 'tax_rate_id',
                'label' => trans('tax_rate'),
                'rules' => 'required'
            ),
            'include_item_tax' => array(
                'field' => 'include_item_tax',
                'label' => trans('tax_rate_placement'),
                'rules' => 'required'
            )
        );
    }

}
