<!DOCTYPE html>
<html lang="<?php echo trans('cldr'); ?>">
<head>
    <title><?php echo trans('Tax Summary'); ?></title>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/<?php echo get_setting('system_theme', 'invoiceplane'); ?>/css/reports.css" type="text/css">
</head>
<body>
<?php foreach($company as $comp_info){ ?>

<div style="text-align: right;">

    <b><?php echo $comp_info->user_company ?></b><br><br>
    <?php echo $comp_info->user_address_1 ?><br><br>
    <?php echo 'TPIN: '. $comp_info->user_tax_code ?><br><br>
    <?php echo 'VAT REG: '.$comp_info->user_vat_id ?>


</div>
<?php }?>

<h3 class="report_title">
    <?php echo trans('Tax Summary'); ?><br/>
    <small><?php echo $from_date . ' - ' . $to_date ?></small>
</h3>

<table>
    <tr>
        <th class = "text-right"><?php echo trans('date'); ?></th>
        <th class = "text-right"><?php echo trans('invoice_number'); ?></th>
        <th class="amount"><?php echo trans('invoice_total'); ?></th>
        <th class="amount"><?php echo trans('Tax Paid'); ?></th>
        
    </tr>
    <?php
    $sum = 0;
    $taxes=0;
    foreach ($tax as $result) {
         $taxes = $result->invoice_tax_total + $result->invoice_item_tax_total;
        ?>
        <tr>
            <td class = "text-right"><?php echo date_from_mysql($result->invoice_date_created, true); ?></td>
            <td class = "text-center"><?php echo _htmlsc($result->invoice_number); ?></td>
            <td class="amount"><?php echo format_currency($result->invoice_total); ?></td>
            <td class="amount"><?php echo format_currency ($taxes); ?></td>

          <?php
            $sum += $taxes; ?>
        </tr>
        <?php
    }

    if (!empty($tax)) {
        ?>
        <tr>
            <td colspan=3><?php echo trans('total'); ?></td>
            <td class="amount text-right"><?php echo format_currency($sum); ?></td>
        </tr>
    <?php } ?>
</table>

</body>
</html>
