<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * expensePlane
 *
 * @author		expensePlane Developers & Contributors
 * @copyright	Copyright (c) 2012 - 2018 expensePlane.com
 * @license		https://expenseplane.com/license.txt
 * @link		https://expenseplane.com
 */

/**
 * Class expense
 */
class Bills extends Admin_Controller
{
    /**
     * expense constructor.
     */
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);

        $this->load->model('mdl_bills');
    }

    /**
     * @param int $page
     */
    public function index($page = 0)
    {
        $this->mdl_bills->paginate(site_url('bills/index'), $page);
        $bills = $this->mdl_bills->result();

        $this->layout->set('bills', $bills);
        $this->layout->buffer('content', 'bills/index');
        $this->layout->render();
    }

    /**
     * @param null $id
     */
    public function form($id = null)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('bills');
        }

        if ($this->mdl_bills->run_validation()) {
            // Get the db array
            $db_array = $this->mdl_bills->db_array();
            $this->mdl_bills->save($id, $db_array);
            redirect('bills');
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_bills->prep_form($id)) {
                show_404();
            }
        }

        $this->load->model('vendors/mdl_vendors');
        $this->load->model('payment_methods/mdl_payment_methods');


        $this->layout->set(
            array(
                'vendors' => $this->mdl_vendors->get()->result(),
                'payment_methods' => $this->mdl_payment_methods->get()->result()

            )
        );

        $this->layout->buffer('content', 'bills/form');
        $this->layout->render();
    }


    public function delete($id)
    {
        $this->mdl_bills->delete($id);
        redirect('bills');
    }



}
