<form method="post">

    <input type="hidden" name="<?php echo $this->config->item('csrf_token_name'); ?>"
           value="<?php echo $this->security->get_csrf_hash() ?>">

    <div id="headerbar">
        <h1 class="headerbar-title"><?php _trans('bill_form'); ?></h1>
        <?php $this->layout->load_view('layout/header_buttons'); ?>
    </div>

    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-md-6 col-md-offset-3">

                <?php $this->layout->load_view('layout/alerts'); ?>

                <div class="panel panel-default mx-auto">
                    <div class="panel-heading">

                        <?php if ($this->mdl_bills->form_value('bill_id')) : ?>
                            #<?php echo $this->mdl_bills->form_value('bill_id'); ?>&nbsp;
                            <?php echo $this->mdl_bills->form_value('bill_name', true); ?>
                        <?php else : ?>
                            <?php _trans('new_bill'); ?> <!--  -->
                        <?php endif; ?>

                    </div>
                    <div class="panel-body">

                        <div class="form-group">
                            <label for="bill_category">
                                <?php _trans('Category'); ?>
                            </label>

                            <select name="bill_category" id="bill_category" class="form-control simple-select">
                                <option value="0"><?php _trans('Select Category'); ?></option>
                                <?php foreach ($vendors as $vendor) { ?>
                                    <option value="<?php echo $vendor->vendor_id; ?>"
                                        <?php check_select($this->mdl_bills->form_value('vendor_id'), $vendor->vendor_id) ?>
                                    ><?php echo $vendor->vendor_name; ?></option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="bill_vendor">
                                <?php _trans('bill_vendor'); ?> (Optional)
                            </label>

                            <input type="text" name="bill_vendor" id="bill_vendor" class="form-control"
                                   value="<?php echo $this->mdl_bills->form_value('bill_vendor', true); ?>">
                        </div>



                        <div class="form-group">
                            <label for="bill_name">
                                <?php _trans('bill_name'); ?>
                            </label>

                            <input type="text" name="bill_name" id="bill_name" class="form-control" required
                                   value="<?php echo $this->mdl_bills->form_value('bill_name', true); ?>">
                        </div>

                        <div class="form-group">
                            <label for="bill_description">
                                <?php _trans('bill_description'); ?>
                            </label>

                            <textarea name="bill_description" id="bill_description" class="form-control"
                                      rows="3"><?php echo $this->mdl_bills->form_value('bill_description', true); ?></textarea>
                        </div>

                        <div class="form-group">
                            <label for="bill_amount">
                                <?php _trans('bill_amount'); ?>
                            </label>

                            <div class="input-group has-feedback">
                                <input type="text" name="bill_amount" id="bill_amount" class="form-control"
                                       value="<?php echo format_amount($this->mdl_bills->form_value('bill_amount')); ?>">
                                <span class="input-group-addon"><?php echo get_setting('currency_symbol'); ?></span>
                            </div>
                        </div>




                    </div>
                </div>
            </div>


        </div>

    </div>

</form>
<div class="col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3">
        <p style="text-align: center;">© <?php echo date("Y"); ?> Penda. A Product by <a href="https://www.irock.co.zm/" target="_blank" rel="noopener">I-Rock</a></p>
    </div>