<div id="headerbar">
    <h1 class="headerbar-title"><?php _trans('Bills'); ?></h1>

    <div class="headerbar-item pull-right">
        <a class="btn btn-sm btn-primary" href="<?php echo site_url('bills/form'); ?>">
            <i class="fa fa-plus"></i> <?php _trans('new'); ?>
        </a>
    </div>

    <div class="headerbar-item pull-right">
        <?php echo pager(site_url('bills/index'), 'mdl_bills'); ?>
    </div>

</div>

<div id="content" class="table-content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div class="table-responsive">
        <table class="table table-hover table-striped">

            <thead>
            <tr>
                <th><?php _trans('Category'); ?></th>
                <th><?php _trans('bill_name'); ?></th>
                <th><?php _trans('bill_description'); ?></th>
                <th style="text-align: right;"><?php _trans('bill_amount'); ?></th>
                <th><?php _trans('bill_vendor'); ?></th>

                <th><?php _trans('options'); ?></th>
            </tr>
            </thead>

            <tbody>
            <?php foreach ($bills as $bill) { ?>
                <tr>
                    <td><?php _htmlsc($bill->vendor_name); ?></td>
                    <td><?php _htmlsc($bill->bill_name); ?></td>
                    <td><?php echo nl2br(htmlsc($bill->bill_description)); ?></td>
                    <td class="amount" ><?php echo format_currency($bill->bill_amount); ?></td>
                    <td><?php _htmlsc($bill->bill_vendor); ?></td>
                    <td>
                        <div class="options btn-group">
                            <a class="btn btn-default btn-sm dropdown-toggle"
                               data-toggle="dropdown" href="#">
                                <i class="fa fa-cog"></i> <?php _trans('options'); ?>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a href="<?php echo site_url('bills/form/' . $bill->bill_id); ?>">
                                        <i class="fa fa-edit fa-margin"></i> <?php _trans('edit'); ?>
                                    </a>
                                </li>
                                <li>
                                    <form action="<?php echo site_url('bills/delete/' . $bill->bill_id); ?>"
                                          method="POST">
                                        <?php _csrf_field(); ?>
                                        <button type="submit" class="dropdown-button"
                                                onclick="return confirm('<?php _trans('delete_record_warning'); ?>');">
                                            <i class="fa fa-trash-o fa-margin"></i> <?php _trans('delete'); ?>
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php } ?>
            </tbody>

        </table>
    </div>
    <div class="col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3">
        <p style="text-align: center;">© <?php echo date("Y"); ?> Penda. A Product by <a href="https://www.irock.co.zm/" target="_blank" rel="noopener">I-Rock</a></p>
    </div>
</div>
