<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Custom_Values
 */
class Mdl_Custom_Values extends MY_Model
{
    public $table = 'pd_custom_values';
    public $primary_key = 'pd_custom_values.custom_values_id';

    /**
     * @return string[]
     */
    public static function custom_types()
    {
        return array_merge(Mdl_Custom_Values::user_input_types(), Mdl_Custom_Values::custom_value_fields());
    }

    /**
     * @return string[]
     */
    public static function user_input_types()
    {
        return array(
            'TEXT',
            'DATE',
            'BOOLEAN'
        );
    }

    /**
     * @return string[]
     */
    public static function custom_value_fields()
    {
        return array(
            'SINGLE-CHOICE',
            'MULTIPLE-CHOICE'
        );
    }

    /**
     * @param $fid
     */
    public function save_custom($fid)
    {
        $field_id = null;

        $this->load->module('custom_fields');
        $field_custom = $this->mdl_custom_fields->get_by_id($fid);

        if (!$field_custom) {
            return;
        }

        $db_array = $this->db_array();
        $db_array['custom_values_field'] = $fid;

        parent::save(null, $db_array);
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(
            'custom_values_value' => array(
                'field' => 'custom_values_value',
                'label' => 'Value',
                'rules' => 'required'
            )
        );
    }

    /**
     * @return array
     */
    public function custom_tables()
    {
        return array(
            'pd_client_custom' => 'client',
            'pd_invoice_custom' => 'invoice',
            'pd_payment_custom' => 'payment',
            'pd_quote_custom' => 'quote',
            'pd_user_custom' => 'user'
        );
    }

    /**
     * @param $id
     * @return $this
     */
    public function get_by_fid($id)
    {
        $this->where('custom_values_field', $id);
        return $this->get();
    }

    /**
     * @param $id
     * @return $this
     */
    public function get_by_column($id)
    {
        $this->where('custom_field_id', $id);
        return $this->get();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function get_by_id($id)
    {
        return $this->where('custom_values_id', $id)->get();
    }

    /**
     * @param $ids
     * @return mixed
     */
    public function get_by_ids($ids)
    {
        $ids = is_array($ids) ? $ids : explode(',', $ids);
        return $this->where_in('custom_values_id', $ids)->get();
    }

    /**
     * @param $fid
     * @param $id
     * @return bool
     */
    public function column_has_value($fid, $id)
    {
        $this->where('custom_field_id', $fid);
        $this->where('custom_values_id', $id);
        $this->get();
        if ($this->num_rows()) {
            return true;
        }
        return false;
    }

    /**
     * @return $this
     */
    public function get_grouped()
    {
        $this->db->select('count(custom_field_label) as count');
        $this->db->group_by('pd_custom_fields.custom_field_id');
        return $this->get();
    }

    public function default_select()
    {
        $this->db->select('pd_custom_fields.*,pd_custom_values.*', false);
    }

    public function default_join()
    {
        $this->db->join('pd_custom_fields', 'pd_custom_values.custom_values_field = pd_custom_fields.custom_field_id', 'inner');
    }

    public function default_order_by()
    {
        //$this->db->group_by('pd_custom_fields.custom_field_label');
    }

    public function default_group_by()
    {
        //$this->db->group_by('pd_custom_values.custom_values_field');
    }
}
