<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Item_Amounts
 */
class Mdl_Expense_Amounts extends CI_Model
{
    /**
     * item_amount_id
     * item_id
     * item_subtotal (item_quantity * item_price)
     * item_tax_total
     * item_total ((item_quantity * item_price) + item_tax_total)
     *
     * @param $item_id
     */
    public function calculate($item_id)
    {
        $this->load->model('invoices/mdl_expense_items');
        $item = $this->mdl_items->get_by_id($item_id);

        $item_subtotal = $item->item_quantity * $item->item_price;
        $item_total = $item_subtotal;

        $db_array = array(
            'item_id' => $item_id,
            'item_subtotal' => $item_subtotal,
            'item_total' => $item_total
        );

        $this->db->where('item_id', $item_id);
        if ($this->db->get('pd_expense_item_amounts')->num_rows()) {
            $this->db->where('item_id', $item_id);
            $this->db->update('pd_expense_item_amounts', $db_array);
        } else {
            $this->db->insert('pd_expense_item_amounts', $db_array);
        }
    }

}
