<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda
 *
 * @author		I-Rock (www.irock.co.zm)
 * @copyright	Copyright (c) 2016 - 2022 irock.co.zm
 * @license		https://www.irock.co.zm
 * @link		https://invoice.irock.co.zm
 */

/**
 * Class Mdl_Items
 */
class Mdl_Expense_Items extends Response_Model
{

    public $table = 'pd_expense_items';

    public $primary_key = 'pd_expense_items.item_id';

    public $date_created_field = 'item_date';

    public function default_select()
    {
        $this->db->select('pd_expense_item_amounts.*, pd_bills.*, pd_expense_items.*');
    }

    public function default_order_by()
    {
        $this->db->order_by('pd_expense_items.item_id');
    }
    public function insert_items($data) {
        // Insert item into database
        return $this->db->insert('pd_expenses_items', $data);
    }

    public function get_items($expense_id) {
        $this->db->select('*');
        $this->db->from('pd_expense_items');
        $this->db->where('pd_expense_items.expense_id', $expense_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function update_items($expense_id, $item_data)
{
    $item_id = $item_data['item_id'];

    if (!empty($item_id)) {
        // Update existing row
        $this->db->where('expense_id', $expense_id);
        $this->db->where('item_id', $item_id);
        $this->db->update('pd_expense_items', $item_data);

        // Check if the update was successful
        if ($this->db->affected_rows() > 0) {
            return true; // Update successful
        } else {
            return false; // Update failed
        }
    } else {
        // Insert new row
        unset($item_data['item_id']); // Remove item_id from the data
        $item_data['expense_id'] = $expense_id; // Set the expense_id

        $this->db->insert('pd_expense_items', $item_data);

        // Check if the insert was successful
        if ($this->db->affected_rows() > 0) {
            return true; // Insert successful
        } else {
            return false; // Insert failed
        }
    }
}

public function insert_item_amounts($data){

    $this->db->insert('pd_expense_item_amounts', $data);

    if ($this->db->affected_rows() > 0) {
        return true; // Insert successful
    } else {
        return false; // Insert failed
    }
}



    public function default_join()
    {
        $this->db->join('pd_expense_item_amounts', 'pd_expense_item_amounts.item_id = pd_expense_items.item_id', 'left');
        $this->db->join('pd_bills', 'pd_bills.bill_id = pd_expense_items.item_bill_id', 'left');
        
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return [

            'item_id' => [
                'field' => 'item_id',
                'label' => trans('item_id'),
            ],
            'expense_id' => [
                'field' => 'expense_id',
                'label' => trans('expense_id'),
            ],
            'item_name' => [
                'field' => 'item_name',
                'label' => trans('item_name'),
                'rules' => 'required',
            ],
            'item_description' => [
                'field' => 'item_description',
                'label' => trans('description'),
            ],
            'item_quantity' => [
                'field' => 'item_quantity',
                'label' => trans('quantity'),
                'rules' => 'required',
            ],
            'item_price' => [
                'field' => 'item_price',
                'label' => trans('price'),
                'rules' => 'required',
            ],
            'item_total' => [
                'field' => 'item_total',
                'label' => trans('Total'),
                'rules' => 'required',
            ],


            'item_bill_id' => [
                'field' => 'item_bill_id',
                'label' => trans('original_product'),
            ],
            'item_date' => [
                'field' => 'item_date',
                'label' => trans('item_date'),
            ],
        ];
    }

    /**
     * @param null $id
     * @param null $db_array
     *
     * @return int|null
     */
    public function save($id = null, $db_array = null)
    {
        $id = parent::save($id, $db_array);

        $this->load->model('expenses/mdl_expense_amounts');
        $this->mdl_item_amounts->calculate($id);





        return $db_array;
    }



    public function delete_item($item_id)
    {
        // Delete the item
        parent::delete($item_id);
        $this->db->where('item_id', $item_id);
        $this->db->delete('pd_expense_items');

        // Check if the deletion was successful
        if ($this->db->affected_rows() > 0) {
            return true; // Deletion successful
        } else {
            return false; // Deletion failed
        }
    }

}
