

<script>
    $(function () {
        $('.item-task-id').each(function () {
            // Disable client chaning if at least one item already has a task id assigned
            if ($(this).val().length > 0) {
                $('#invoice_change_client').hide();
                return false;
            }
        });

        $('.btn_add_product').click(function () {
            $('#modal-placeholder').load(
                "<?php echo site_url('bills/ajax/modal_bills_lookups'); ?>/" + Math.floor(Math.random() * 1000)
            );
        });


        $('.btn_add_row').click(function () {
            $('#new_row').clone().appendTo('#item_table').removeAttr('id').addClass('item').show();
        });

        $(document).on('click', '.btn_delete_item', function () {
            var btn = $(this);
            var item_id = btn.data('item-id');

            console.log(item_id);

            // Just remove the row if no item ID is set (new row)
            if (typeof item_id === 'undefined') {
                $(this).parents('.item').remove();
            }

            $.post("<?php echo site_url('expenses/ajax/delete_item/'); ?>", {
                    'item_id': item_id,
                },
                function (data) {
                    <?php echo(IP_DEBUG ? 'console.log(data);' : ''); ?>
                    var response = JSON.parse(data);

                    // console.log(data);

                    if (response.success === 1) {
                        btn.parents('.item').remove();
                        console.log('Successfully Deleted Item');
                    } else {
                        btn.removeClass('btn-link').addClass('btn-danger').prop('disabled', true);
                    }
                });
        });

        $(document).on('click', '.btn_delete_item', function () {
            var btn = $(this);
            var item_id = btn.data('item-id');

            console.log(item_id);

            // Just remove the row if no item ID is set (new row)
            if (typeof item_id === 'undefined') {
                $(this).parents('.item').remove();
            }

            $.post("<?php echo site_url('expenses/ajax/delete_item/'); ?>", {
                    'item_id': item_id,
                },
                function (data) {
                    <?php echo(IP_DEBUG ? 'console.log(data);' : ''); ?>
                    var response = JSON.parse(data);

                    // console.log(data);

                    if (response.success === 1) {  
                        btn.parents('.item').remove();
                        console.log('Successfully Deleted Item');
                    } else {
                        btn.removeClass('btn-link').addClass('btn-danger').prop('disabled', true);
                    }
                });
        });

        // $(document).on('click', '.btn_delete_item', function() {
        //     var btn = $(this);
        //     var item_id = btn.data('item-id');

        //     console.log(item_id);
        // });


        $('#btn_update_expense').click(function () {
                var items = [];
                var item_order = 1;
                $('table tbody.item').each(function () {
                    var row = {};
                    $(this).find('input,select,textarea').each(function () {
                        if ($(this).is(':checkbox')) {
                            row[$(this).attr('name')] = $(this).is(':checked');
                        } else {
                            row[$(this).attr('name')] = $(this).val();
                        }
                    });
                    row['item_order'] = item_order;
                    item_order++;
                    items.push(row);
                });
                console.log('expense_name:', $('#expense_name').val());
                console.log('expense_date_created:', $('#expense_date').val());
                console.log('expense_status:', $('#expense_status').val());
                console.log('expense_id:',$('#expense_id').val());
                console.log('items:', JSON.stringify(items));
                $.post("<?php echo site_url('expenses/ajax/update/') ?>" + $('#expense_id').val(), {

                        expense_name: $('#expense_name').val(),
                        expense_date_created: $('#expense_date').val(),
                        expense_status: $('#expense_status').val(),
                        items: JSON.stringify(items)
                    },
                    function (data) {
                        console.log('response:', data);
                        var response = JSON.parse(data);
                        if (response.success === 1) {
                            window.location = "<?php echo site_url('expenses/edit/'); ?>" + $('#expense_id').val()
                        } else {
                            $('#fullpage-loader').hide();
                            $('.control-group').removeClass('has-error');
                            $('div.alert[class*="alert-"]').remove();
                            var resp_errors = response.validation_errors,
                                all_resp_errors = '';
                            for (var key in resp_errors) {
                                $('#' + key).parent().addClass('has-error');
                                all_resp_errors += resp_errors[key];
                            }
                            $('#expense_form').prepend('<div class="alert alert-danger">' + all_resp_errors + '</div>');
                        }
                    });
                });



    });


</script>

<?php foreach ($expenses as $expense) {?>

<div id="delete-expense" class="modal modal-lg" role="dialog" aria-labelledby=delete-expense" aria-hidden="true">

    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><i class="fa fa-close"></i></button>
            <h4 class="panel-title"><?php _trans('delete_invoice'); ?></h4>
        </div>
        <div class="modal-body">

            <div class="alert alert-danger"><?php _trans('delete_invoice_warning'); ?></div>

        </div>
        <div class="modal-footer">

            <form action="<?php echo site_url('expenses/delete/' .$expense['expense_id']); ?>"
                  method="POST">
                <?php _csrf_field(); ?>

                <div class="btn-group">
                    <button type="submit" class="btn btn-danger">
                        <i class="fa fa-trash-o fa-margin"></i> <?php echo trans('confirm_deletion') ?>
                    </button>
                    <a href="#" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> <?php _trans('cancel'); ?>
                    </a>
                </div>
            </form>

        </div>
    </div>

</div>


<form method="post">

    <input type="hidden" name="<?php echo $this->config->item('csrf_token_name'); ?>"
           value="<?php echo $this->security->get_csrf_hash() ?>">



    <div id="headerbar">
        <h1 class="headerbar-title"><?php _trans('expense_form'); ?></h1>

        <div class="headerbar-item pull-right btn-group">
        <div class="options btn-group btn-group-sm">
            <a class="btn btn-sm btn-default dropdown-toggle" data-toggle="dropdown" href="#">
                <i class="fa fa-caret-down no-margin"></i> <?php _trans('Options'); ?>
            </a>
            <ul class="dropdown-menu">


                <li>
                    <a href="<?php echo site_url('expenses/generate_pdf/') .$expense['expense_id']?>" id="btn_generate_pdf"
                       data-expense-id="" target="_blank">
                        <i class="fa fa-print fa-margin"></i>
                        <?php _trans('download_pdf'); ?>
                    </a>
                </li>

                <li class="divider"></li>


                <li>
                        <a href="#delete-expense" data-toggle="modal">
                            <i class="fa fa-trash-o fa-margin"></i>
                            <?php _trans('delete'); ?>
                        </a>
                    </li>


            </ul>
        </div>

        <a href="#" class="btn btn-sm btn-success ajax-loader" id="btn_update_expense">
                <i class="fa fa-check"></i> <?php _trans('save'); ?>
            </a>
        </div>
    </div>



    <div id="content">

            <?php echo $this->layout->load_view('layout/alerts'); ?>

        <div id="expense_form">
            <div class="expenses">



                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-5">
                            <div class="panel panel-default">


                                <div class="panel-body">



                                    <input type="hidden" id="expense_id" name="expense_id" value="<?php echo $expense['expense_id'] ?>">

                                    <div class="form-group">
                                        <label>
                                            Expense Name
                                        </label>
                                            <input type="text" name="expense_name" id="expense_name"
                                                class="form-control input-sm "
                                                value="<?php echo $expense['expense_name'] ?>">

                                    </div>
                                    <label>
                                            Date
                                        </label>
                                    <div class="input-group">
                                       
                                        <input name="expense_date" id="expense_date" class="form-control input-sm datepicker"
                                            value="<?php echo $expense['expense_date_created'] ?>">
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar fa-fw"></i>
                                        </span>
                                    </div>
                                    <div class="form-group">
                                        <label>
                                            Status
                                        </label>

                                        <select class="form-control" name="expense_status" id="expense_status">
                                            <option value="0" <?php if ($expense['expense_status'] == 0) echo 'selected'; ?>>Draft</option>
                                            <option value="1" <?php if ($expense['expense_status'] == 1) echo 'selected'; ?>>Paid</option>
                                        </select>



                                    </div>
                                    <?php }?>

                                </div>



                            </div>

                            <br>


                        </div>

                    </div>

            <?php $this->layout->load_view('expenses/edit_items_table'); ?>
        </div>
    </div>

    </div>

</form>
