

<script>
    $(function () {
        $('.item-task-id').each(function () {
            // Disable client chaning if at least one item already has a task id assigned
            if ($(this).val().length > 0) {
                $('#invoice_change_client').hide();
                return false;
            }
        });

        $('.btn_add_product').click(function () {
            $('#modal-placeholder').load(
                "<?php echo site_url('bills/ajax/modal_bills_lookups'); ?>/" + Math.floor(Math.random() * 1000)
            );
        });



        $('.btn_add_row').click(function () {
            $('#new_row').clone().appendTo('#item_table').removeAttr('id').addClass('item').show();
        });









        $(document).on('click', '.btn_delete_item', function () {
            var btn = $(this);
            var item_id = btn.data('item-id');

            // Just remove the row if no item ID is set (new row)
            if (typeof item_id === 'undefined') {
                $(this).parents('.item').remove();
            }

            $.post("<?php echo site_url('bills/ajax/delete_item/' ); ?>", {
                    'item_id': item_id,
                },
                function (data) {
                    <?php echo(IP_DEBUG ? 'console.log(data);' : ''); ?>
                    var response = JSON.parse(data);

                    if (response.success === 1) {
                        btn.parents('.item').remove();
                    } else {
                        btn.removeClass('btn-link').addClass('btn-danger').prop('disabled', true);
                    }
                });
        });

        $('#btn_save_expense').click(function () {
                var items = [];
                var item_order = 1;
                $('table tbody.item').each(function () {
                    var row = {};
                    $(this).find('input,select,textarea').each(function () {
                        if ($(this).is(':checkbox')) {
                            row[$(this).attr('name')] = $(this).is(':checked');
                        } else {
                            row[$(this).attr('name')] = $(this).val();
                        }
                    });
                    row['item_order'] = item_order;
                    item_order++;
                    items.push(row);
                });
                console.log('expense_name:', $('#expense_name').val());
                console.log('expense_date_created:', $('#expense_date').val());
                console.log('expense_status:', $('#expense_status').val());
                console.log('items:', JSON.stringify(items));
                $.post("<?php echo site_url('expenses/ajax/save'); ?>", {
                        expense_name: $('#expense_name').val(),
                        expense_date_created: $('#expense_date').val(),
                        expense_status: $('#expense_status').val(),
                        items: JSON.stringify(items)
                    },
                    function (data) {
                        console.log('response:', data);
                        var response = JSON.parse(data);
                        if (response.success === 1) {

                            window.location = "<?php echo site_url('expenses/edit/'); ?>" + response.expense_id ;
                            
                        } else {
                            $('#fullpage-loader').hide();
                            $('.control-group').removeClass('has-error');
                            $('div.alert[class*="alert-"]').remove();
                            var resp_errors = response.validation_errors,
                                all_resp_errors = '';
                            for (var key in resp_errors) {
                                $('#' + key).parent().addClass('has-error');
                                all_resp_errors += resp_errors[key];
                            }
                            $('#expense_form').prepend('<div class="alert alert-danger">' + all_resp_errors + '</div>');
                        }
                    });
                });



    });


</script>





<form method="post">

    <input type="hidden" name="<?php echo $this->config->item('csrf_token_name'); ?>"
           value="<?php echo $this->security->get_csrf_hash() ?>">

    <div id="headerbar">
        <h1 class="headerbar-title"><?php _trans('expense_form'); ?></h1>

        <div class="headerbar-item pull-right btn-group">

        <a href="#" class="btn btn-sm btn-success ajax-loader" id="btn_save_expense">
                <i class="fa fa-check"></i> <?php _trans('save'); ?>
            </a>
        </div>
    </div>



    <div id="content">

            <?php echo $this->layout->load_view('layout/alerts'); ?>

        <div id="expense_form">
            <div class="expenses">



                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-5">
                            <div class="panel panel-default">
                                <div class="panel-body">

                                    <div class="form-group">
                                        <label>
                                            Expense Name (Optional)
                                        </label>
                                            <input type="text" name="expense_name" id="expense_name"
                                                class="form-control input-sm "
                                                value="">

                                    </div>
                                    <label>
                                            Date
                                        </label>
                                    <div class="input-group">
                                       
                                        <input name="expense_date" id="expense_date" class="form-control input-sm datepicker"
                                        value="<?php echo date('Y-m-d'); ?>">
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar fa-fw"></i>
                                        </span>
                                    </div>

                                    <div class="form-group">
                                        <label>
                                            Status
                                        </label>

                                                          <select class="form-control" name="expense_status" id="expense_status">
                                                            <option value="0">Draft</option>
                                                            <option value="1">Paid</option>

                                                          </select>


                                    </div>

                                </div>


                            </div>

                            <br>


                        </div>

                    </div>

            <?php $this->layout->load_view('expenses/partial_item_table'); ?>
        </div>
    </div>

    </div>

</form>

