<div id="headerbar">
    <h1 class="headerbar-title"><?php _trans('Expenses'); ?></h1>

    <div class="headerbar-item pull-right">
        <a class="btn btn-sm btn-primary" href="<?php echo site_url('expenses/form'); ?>">
            <i class="fa fa-plus"></i> <?php _trans('new'); ?>
        </a>
    </div>

    <div class="headerbar-item pull-right">
        <?php echo pager(site_url('expenses/index'), 'mdl_expenses'); ?>
    </div>

</div>

<div id="content" class="table-content">

    <?php $this->layout->load_view('layout/alerts'); ?>

    <div class="table-responsive">
        <table class="table table-hover table-striped">

            <thead>
            <tr>
                <th><?php _trans('Status'); ?></th>
                <th><?php _trans('Expense'); ?></th>
                <th><?php _trans('Expense Name'); ?></th>
                <th><?php _trans('No. of Bills'); ?></th>
                <th style="text-align: right;"><?php _trans('Total Amount'); ?></th>
                <th ><?php _trans('Expense Date'); ?></th>

                <th><?php _trans('options'); ?></th>
            </tr>
            </thead>

            <tbody>
            <?php foreach ($expenses as $expense) { ?>
                <tr>

                     <td>
					<?php echo $expense['expense_status'] ? '<span class="label active">' . trans('Paid') . '</span>' : '<span class="label draft">' . trans('Draft') . '</span>'; ?>
				</td>
                    <td>
                    <a href="<?php echo site_url('expenses/edit/' . $expense['expense_id']); ?>"
                       title="<?php _trans('edit'); ?>">
                        <?php echo($expense['expense_id']); ?>
                    </a>
                </td>

                    <td><?php _htmlsc($expense['expense_name']); ?></td>
                    <td><?php echo nl2br(htmlsc($expense['item_count'])); ?></td>
                    <td class="amount"><?php echo format_currency($expense['total_amount']); ?></td>
                    <td><?php _htmlsc($expense['expense_date_created']); ?></td>

                    <td>
                        <div class="options btn-group">
                            <a class="btn btn-default btn-sm dropdown-toggle"
                               data-toggle="dropdown" href="#">
                                <i class="fa fa-cog"></i> <?php _trans('options'); ?>
                            </a>
                            <ul class="dropdown-menu">
                            <li>
                                    <a href="<?php echo site_url('expenses/generate_pdf/') .$expense['expense_id']?>">
                                    <i class="fa fa-print fa-margin"></i> <?php _trans('Download PDF'); ?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo site_url('expenses/edit/' . $expense['expense_id']); ?>">
                                        <i class="fa fa-edit fa-margin"></i> <?php _trans('edit'); ?>
                                    </a>
                                </li>
                                <li>
                                    <form action="<?php echo site_url('expenses/delete/' . $expense['expense_id']); ?>"
                                          method="POST">
                                        <?php _csrf_field(); ?>
                                        <button type="submit" class="dropdown-button"
                                                onclick="return confirm('<?php _trans('delete_record_warning'); ?>');">
                                            <i class="fa fa-trash-o fa-margin"></i> <?php _trans('delete'); ?>
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php } ?>
            </tbody>

        </table>
    </div>

</div>
<div class="col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3">
        <p style="text-align: center;">© <?php echo date("Y"); ?> Penda. A Product by <a href="https://www.irock.co.zm/" target="_blank" rel="noopener">I-Rock</a></p>
    </div>
