<script>
    $(function () {
        // Display the create invoice modal
        $('#modal-choose-items').modal('show');

        $(".simple-select").select2();

        // Creates the invoice
        $('.select-items-confirm').click(function () {
            var bill_ids = [];

            $("input[name='bill_ids[]']:checked").each(function () {
                bill_ids.push(parseInt($(this).val()));
            });

            $.post("<?php echo site_url('bills/ajax/process_bill_selections'); ?>", {
                bill_ids: bill_ids
            }, function (data) {
                <?php echo(IP_DEBUG ? 'console.log(data);' : ''); ?>
                var items = JSON.parse(data);

                for (var key in items) {
                    // Set default tax rate id if empty


                    if ($('#item_table tbody:last input[name=item_name]').val() !== '') {
                        $('#new_row').clone().appendTo('#item_table').removeAttr('id').addClass('item').show();
                    }

                    var last_item_row = $('#item_table tbody:last');

                    last_item_row.find('input[name=item_name]').val(items[key].bill_name);
                    last_item_row.find('textarea[name=item_description]').val(items[key].bill_description);
                    last_item_row.find('input[name=item_price]').val(items[key].bill_amount.replace(',', ''));
                    last_item_row.find('input[name=item_quantity]').val('1');
                    last_item_row.find('input[name=item_bill_id]').val(items[key].bill_id);

                    $('#modal-choose-items').modal('hide');
                }
            });
        });

        // Toggle checkbox when click on row
        $(document).on('click', '.bill', function (event) {
            if (event.target.type !== 'checkbox') {
                $(':checkbox', this).trigger('click');
            }
        });

        // Reset the form
        $('#bill-reset-button').click(function () {
            var bill_table = $('#bill-lookup-table');

            bill_table.html('<h2 class="text-center"><i class="fa fa-spin fa-spinner"></i></h2>');

            var lookup_url = "<?php echo site_url('bills/ajax/modal_bill_lookups'); ?>/";
            lookup_url += Math.floor(Math.random() * 1000) + '/?';
            lookup_url += "&reset_table=true";

            // Reload modal with settings
            window.setTimeout(function () {
                bill_table.load(lookup_url);
            }, 250);
        });

        // Filter on search button click
        $('#filter-button').click(function () {
            bill_filter();
        });

        // Filter on vendor dropdown change
        $("#filter_vendor").change(function () {
            bill_filter();
        });

        // Filter bill
        function bill_filter() {
            var filter_vendor = $('#filter_vendor').val();
            var filter_bill = $('#filter_bill').val();
            var bill_table = $('#bill-lookup-table');

            bill_table.html('<h2 class="text-center"><i class="fa fa-spin fa-spinner"></i></h2>');

            var lookup_url = "<?php echo site_url('bills/ajax/modal_bill_lookups'); ?>/";
            lookup_url += Math.floor(Math.random() * 1000) + '/?';

            if (filter_vendor) {
                lookup_url += "&filter_vendor=" + filter_vendor;
            }

            if (filter_bill) {
                lookup_url += "&filter_bill=" + filter_bill;
            }

            // Reload modal with settings
            window.setTimeout(function () {
                bill_table.load(lookup_url);
            }, 250);
        }

        // Bind enter to bill search if search field is focused
        $(document).keypress(function(e){
            if (e.which === 13 && $('#filter_bill').is(':focus')){
                $('#filter-button').click();
                return false;
            }
        });
    });
</script>

<div id="modal-choose-items" class="modal col-xs-12 col-sm-10 col-sm-offset-1"
     role="dialog" aria-labelledby="modal-choose-items" aria-hidden="true">
    <form class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal"><i class="fa fa-close"></i></button>
            <h4 class="panel-title"><?php _trans('add_expense'); ?></h4>
        </div>
        <div class="modal-body">

            <div class="form-inline">
                <div class="form-group filter-form">
                    <select name="filter_vendor" id="filter_vendor" class="form-control simple-select">
                        <option value=""><?php _trans('Categories'); ?></option>
                        <?php foreach ($vendors as $vendor) { ?>
                            <option value="<?php echo $vendor->vendor_id; ?>"
                                <?php if (isset($filter_vendor) && $vendor->vendor_id == $filter_vendor) {
                                    echo ' selected="selected"';
                                } ?>>
                                <?php _htmlsc($vendor->vendor_name); ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="form-group">
                    <input type="text" class="form-control" name="filter_bill" id="filter_bill"
                           placeholder="<?php _trans('expense_name'); ?>"
                           value="<?php echo $filter_bill ?>">
                </div>
                <button type="button" id="filter-button"
                        class="btn btn-default"><?php _trans('search_expense'); ?></button>
                <button type="button" id="bill-reset-button" class="btn btn-default">
                    <?php _trans('reset'); ?>
                </button>
            </div>

            <br/>

            <div id="bill-lookup-table">
                <?php $this->layout->load_view('bills/partial_bills_table_modal'); ?>
            </div>

        </div>
        <div class="modal-footer">
            <div class="btn-group">
                <button class="select-items-confirm btn btn-success" type="button">
                    <i class="fa fa-check"></i>
                    <?php _trans('submit'); ?>
                </button>
                <button class="btn btn-danger" type="button" data-dismiss="modal">
                    <i class="fa fa-times"></i>
                    <?php _trans('cancel'); ?>
                </button>
            </div>
        </div>
    </form>

</div>
<div class="col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3">
        <p style="text-align: center;">© <?php echo date("Y"); ?> Penda. A Product by <a href="https://www.irock.co.zm/" target="_blank" rel="noopener">I-Rock</a></p>
    </div>
