<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Payment_Logs
 */
class Mdl_Payment_Logs extends Response_Model
{
    public $table = 'pd_merchant_responses';
    public $primary_key = 'pd_merchant_responses.merchant_response_id';

    public function default_select()
    {
        $this->db->select("
            pd_invoices.invoice_number,
            pd_merchant_responses.*", false);
    }

    public function default_order_by()
    {
        $this->db->order_by('pd_merchant_responses.merchant_response_id DESC');
    }

    public function default_join()
    {
        $this->db->join('pd_invoices', 'pd_invoices.invoice_id = pd_merchant_responses.invoice_id');
    }

}
