<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Projects
 */
class Mdl_Projects extends Response_Model
{
    public $table = 'pd_projects';
    public $primary_key = 'pd_projects.project_id';

    public function default_select()
    {
        $this->db->select('SQL_CALC_FOUND_ROWS *', false);
    }

    public function default_order_by()
    {
        $this->db->order_by('pd_projects.project_id');
    }

    public function default_join()
    {
        $this->db->join('pd_clients', 'pd_clients.client_id = pd_projects.client_id', 'left');
    }

    public function get_latest()
    {
        $this->db->order_by('pd_projects.project_id', 'DESC');
        return $this;
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(
            'project_name' => array(
                'field' => 'project_name',
                'label' => trans('project_name'),
                'rules' => 'required'
            ),
            'client_id' => array(
                'field' => 'client_id',
                'label' => trans('client'),
            )
        );
    }

    public function get_tasks($project_id)
    {
        $result = array();

        if (!$project_id) {
            return $result;
        }

        $this->load->model('tasks/mdl_tasks');
        $query = $this->mdl_tasks
            ->where('pd_tasks.project_id', $project_id)
            ->get();

        foreach ($query->result() as $row) {
            $result[] = $row;
        }

        return $result;
    }

}
