<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda
 *
 * @author		I-Rock (www.irock.co.zm)
 * @copyright	Copyright (c) 2016 - 2022 irock.co.zm
 * @license		https://www.irock.co.zm
 * @link		https://invoice.irock.co.zm
 */

/**
 * Class Reports
 */
class Reports extends Admin_Controller
{
    /**
     * Reports constructor.
     */
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);


        $this->load->model('mdl_reports');
    }

    public function profit_loss(){
   

        if ($this->input->post('btn_submit')) {
            $data = array(
                'incomes' => $this->mdl_reports->invoice_amounts($this->input->post('from_date'), $this->input->post('to_date')),
                'expenses' => $this->mdl_reports->expense_amounts($this->input->post('from_date'), $this->input->post('to_date')),
                'company_info' => $this->mdl_reports->get_company(),
                'from_date' => $this->input->post('from_date'),
                'to_date' => $this->input->post('to_date'),
            );

            $html = $this->load->view('reports/profit_loss', $data, true);

            $this->load->helper('mpdf');

            pdf_create($html, trans('Profit and Loss'), true);
        }

        $this->layout->buffer('content', 'reports/profit_loss_index')->render();

    // Access and use the results as needed

}

public function userlogs(){
    if ($this->session->userdata('user_id')==2){
   
    $data = array (
        'userlogs' => $this->mdl_reports->userlogs(),
        'count' => $this->mdl_reports->user_logs_count()

    );

   
        $this->layout->set($data);
        $this->layout->buffer('content', 'reports/userlogs');
        $this->layout->render();
} else{
    redirect(base_url(), 'refresh');
}
    
}

public function delete($id)
    {
         if ($this->input->post('btn_submit')) {
             
           $userlogs = $this->mdl_reports->delete($id);  
         }
        // Get the status of the invoice
        
       

            
        if($userlogs){
            // Delete the record

             $this->session->set_flashdata('alert_error', trans('Successful'));


        } else {
            // Add alert that invoices can't be deleted
            $this->session->set_flashdata('alert_error', trans('Unsuccessful'));
        }

        // Redirect to invoice index
        redirect('reports/userlogs');
    }

public function tax_summary(){
   

    if ($this->input->post('btn_submit')) {
        $data = array(
            'tax' => $this->mdl_reports->getInvoices($this->input->post('from_date'), $this->input->post('to_date')),
            'company' => $this->mdl_reports->get_company(),
            'from_date' => $this->input->post('from_date'),
            'to_date' => $this->input->post('to_date'),
        );

        $html = $this->load->view('reports/tax_summary', $data, true);

        $this->load->helper('mpdf');

        pdf_create($html, trans('Tax Summary'), true);
    }

    $this->layout->buffer('content', 'reports/tax_summary_index')->render();

// Access and use the results as needed

}

    public function sales_by_client()
    {
       
        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->sales_by_client($this->input->post('from_date'), $this->input->post('to_date')),
                'from_date' => $this->input->post('from_date'),
                'to_date' => $this->input->post('to_date'),
                'company' => $this->mdl_reports->get_company(),
            );

            $html = $this->load->view('reports/sales_by_client', $data, true);

            $this->load->helper('mpdf');

            pdf_create($html, trans('sales_by_client'), true);
        }

        $this->layout->buffer('content', 'reports/sales_by_client_index')->render();
    }

    public function payment_history()
    {
        $CI = &get_instance();
        $company=$CI->mdl_reports->get_company();
        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->payment_history($this->input->post('from_date'), $this->input->post('to_date')),
                'from_date' => $this->input->post('from_date'),
                'to_date' => $this->input->post('to_date'),
                'company' => $company,
            );

            $html = $this->load->view('reports/payment_history', $data, true);

            $this->load->helper('mpdf');

            pdf_create($html, trans('payment_history'), true);
        }

        $this->layout->buffer('content', 'reports/payment_history_index')->render();
    }

    public function invoice_aging()
{
    if ($this->input->post('btn_submit')) {
        $data = array(
            'results' => $this->mdl_reports->invoice_aging(),
            'company' => $this->mdl_reports->get_company(), 
        );

        $html = $this->load->view('reports/invoice_aging', $data, true);

        $this->load->helper('mpdf');

        $pdf_content = pdf_create($html, trans('invoice_aging'), true);

        // Set the response headers to indicate PDF content
        header('Content-Type: application/pdf');
        header('Content-Disposition: inline; filename="invoice_aging.pdf"');

        // Output the PDF content
        echo $pdf_content;
        return;
    }

    $this->layout->buffer('content', 'reports/invoice_aging_index')->render();
}


    public function sales_by_year()
    {

        if ($this->input->post('btn_submit')) {
            $data = array(
                'results' => $this->mdl_reports->sales_by_year($this->input->post('from_date'), $this->input->post('to_date'), $this->input->post('minQuantity'), $this->input->post('maxQuantity'), $this->input->post('checkboxTax')),
                'from_date' => $this->input->post('from_date'),
                'to_date' => $this->input->post('to_date'),
            );

            $html = $this->load->view('reports/sales_by_year', $data, true);

            $this->load->helper('mpdf');

            pdf_create($html, trans('sales_by_date'), true);
        }

        $this->layout->buffer('content', 'reports/sales_by_year_index')->render();
    }

}
