<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda
 *
 * @author		I-Rock (www.irock.co.zm)
 * @copyright	Copyright (c) 2016 - 2022 irock.co.zm
 * @license		https://www.irock.co.zm
 * @link		https://invoice.irock.co.zm
 */

/**
 * Class Mdl_Reports
 */
class Mdl_Reports extends CI_Model
{
    /**
     * @param null $from_date
     * @param null $to_date
     * @return mixed
     */
    public function invoice_amounts($fromDate, $toDate)
{
    $from_date = date_to_mysql($fromDate);
        $to_date = date_to_mysql($toDate);
    
    $this->db->select('ia.invoice_item_subtotal, ia.invoice_item_tax_total, ia.invoice_tax_total, ia.invoice_paid');
    $this->db->from('pd_invoice_amounts ia');
    $this->db->join('pd_invoices inv', 'ia.invoice_id = inv.invoice_id');
    $this->db->where('DATE(ia.date_modified) >=', $from_date);
    $this->db->where('DATE(ia.date_modified) <=', $to_date);
    $this->db->where('inv.invoice_status_id', '4');

    $query = $this->db->get();
    $result = $query->result();

    return $result;
}

 


    public function get_company() {
        $email =$this->session->userdata('user_email');
        $this->db->select('*');
        $this->db->from('pd_users');
        $this->db->where('user_email', $email); // Add this line to filter active clients
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Empty array if no results
        } 
    }
    
    public function userlogs(){
        $this->db->select('*');
        $this->db->from('pd_userlogs');
        $this->db->order_by("loginTime", "desc");
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Empty array if no results
        } 
        
        
    }

    public function user_logs_count() {
        // Select the count of user logs from the 'user_logs' table
        $this->db->select('COUNT(*) as log_count');
        $query = $this->db->get('pd_userlogs');
        
        // Check if query was successful
        if ($query->num_rows() > 0) {
            // Fetch the result
            $result = $query->row();
            // Return the count of user logs
            return $result->log_count;
        } else {
            // Return 0 if no logs found
            return 0;
        }
    }

    /**
     * @param null $from_date
     * @param null $to_date
     * @return mixed
     */
    public function expense_amounts($fromDate, $toDate)
{
    $from_date = date_to_mysql($fromDate);
    $to_date = date_to_mysql($toDate);
    $this->db->select('exp_items.item_id, pd_vendors.vendor_name AS Category, exp_items.item_total, exp.expense_date_created');
    $this->db->from('pd_expense_items exp_items');
    $this->db->join('pd_expenses exp', 'exp_items.expense_id = exp.expense_id');
    $this->db->join('pd_bills', 'exp_items.item_bill_id = pd_bills.bill_id', 'left');
    $this->db->join('pd_vendors', 'pd_bills.bill_category = pd_vendors.vendor_id', 'left');
    $this->db->where('exp.expense_status', '1');
    $this->db->where('DATE(exp.expense_date_created) >=', $from_date);
    $this->db->where('DATE(exp.expense_date_created) <=', $to_date);

    $query = $this->db->get();
    $result = $query->result();

    return $result;
}


    public function getInvoices($fromDate, $toDate)
{
    $from_date = date_to_mysql($fromDate);
    $to_date = date_to_mysql($toDate);
    $this->db->select('a.*, pd_invoices.invoice_status_id, pd_invoices.invoice_date_created,invoice_number');
    $this->db->from('pd_invoice_amounts a');
    $this->db->join('pd_invoices', 'a.invoice_id = pd_invoices.invoice_id');
    $this->db->where('pd_invoices.invoice_status_id', '4');

    if (!empty($from_date) && !empty($to_date)) {
        $this->db->where('pd_invoices.invoice_date_created >=', $from_date);
        $this->db->where('pd_invoices.invoice_date_created <=', $to_date);
    }

    $query = $this->db->get();
    $result = $query->result();

    return $result;
}


    public function company_info() {
        $email =$this->session->userdata('user_email');
        $this->db->select('*');
        $this->db->from('pd_users');
        $this->db->where('user_email', $email); // Add this line to filter active clients
        $query = $this->db->get();
    
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Empty array if no results
        } 
    }

    /**
     * @param null $from_date
     * @param null $to_date
     * @return mixed
     */
    public function sales_by_client($from_date = null, $to_date = null)
    {
        $this->db->select('client_name, client_surname, CONCAT(client_name," ", client_surname) AS client_namesurname');

        if ($from_date and $to_date) {

            $from_date = date_to_mysql($from_date);
            $to_date = date_to_mysql($to_date);

            $this->db->select("
            (
                SELECT COUNT(*) FROM pd_invoices
                    WHERE pd_invoices.client_id = pd_clients.client_id
                        AND invoice_date_created >= " . $this->db->escape($from_date) . "
                        AND invoice_date_created <= " . $this->db->escape($to_date) . "
            ) AS invoice_count");

            $this->db->select("
            (
                SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                    WHERE pd_invoice_amounts.invoice_id IN
                    (
                        SELECT invoice_id FROM pd_invoices
                            WHERE pd_invoices.client_id = pd_clients.client_id
                                AND invoice_date_created >= " . $this->db->escape($from_date) . "
                                AND invoice_date_created <= " . $this->db->escape($to_date) . "
                    )
            ) AS sales");

            $this->db->select("
            (
                SELECT SUM(invoice_total) FROM pd_invoice_amounts
                    WHERE pd_invoice_amounts.invoice_id IN
                    (
                        SELECT invoice_id FROM pd_invoices
                            WHERE pd_invoices.client_id = pd_clients.client_id
                                AND invoice_date_created >= " . $this->db->escape($from_date) . "
                                AND invoice_date_created <= " . $this->db->escape($to_date) . "
                    )
            ) AS sales_with_tax");

            $this->db->where('
                client_id IN
                (
                    SELECT client_id FROM pd_invoices
                        WHERE invoice_date_created >=' . $this->db->escape($from_date) . '
                            AND invoice_date_created <= ' . $this->db->escape($to_date) . '
                )');

        } else {

            $this->db->select('
            (
                SELECT COUNT(*) FROM pd_invoices
                    WHERE pd_invoices.client_id = pd_clients.client_id
            ) AS invoice_count');

            $this->db->select('
            (
                SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                    WHERE pd_invoice_amounts.invoice_id IN
                    (
                        SELECT invoice_id FROM pd_invoices
                            WHERE pd_invoices.client_id = pd_clients.client_id
                    )
            ) AS sales');

            $this->db->select('
            (
                SELECT SUM(invoice_total) FROM pd_invoice_amounts
                    WHERE pd_invoice_amounts.invoice_id IN
                    (
                        SELECT invoice_id FROM pd_invoices
                            WHERE pd_invoices.client_id = pd_clients.client_id
                    )
            ) AS sales_with_tax');

            $this->db->where('client_id IN (SELECT client_id FROM pd_invoices)');

        }

        $this->db->order_by('client_namesurname');

        return $this->db->get('pd_clients')->result();
    }

    /**
     * @param null $from_date
     * @param null $to_date
     * @return mixed
     */
    public function payment_history($from_date = null, $to_date = null)
    {
        $this->load->model('payments/mdl_payments');

        if ($from_date and $to_date) {
            $from_date = date_to_mysql($from_date);
            $to_date = date_to_mysql($to_date);

            $this->mdl_payments->where('payment_date >=', $from_date);
            $this->mdl_payments->where('payment_date <=', $to_date);
        }

        return $this->mdl_payments->get()->result();
    }

    /**
     * @return mixed
     */
    public function invoice_aging()
    {
        $this->db->select('client_name, client_surname');

        $this->db->select('
        (
            SELECT SUM(invoice_balance) FROM pd_invoice_amounts
                WHERE invoice_id IN
                (
                    SELECT invoice_id FROM pd_invoices
                        WHERE pd_invoices.client_id = pd_clients.client_id
                            AND invoice_date_due <= DATE_SUB(NOW(),INTERVAL 1 DAY)
                            AND invoice_date_due >= DATE_SUB(NOW(), INTERVAL 15 DAY)
                )
        ) AS range_1', false);

        $this->db->select('
        (
            SELECT SUM(invoice_balance) FROM pd_invoice_amounts
                WHERE invoice_id IN
                (
                    SELECT invoice_id FROM pd_invoices
                        WHERE pd_invoices.client_id = pd_clients.client_id
                            AND invoice_date_due <= DATE_SUB(NOW(),INTERVAL 16 DAY)
                            AND invoice_date_due >= DATE_SUB(NOW(), INTERVAL 30 DAY)
                )
        ) AS range_2', false);

        $this->db->select('
        (
            SELECT SUM(invoice_balance) FROM pd_invoice_amounts
                WHERE invoice_id IN
                (
                    SELECT invoice_id FROM pd_invoices
                        WHERE pd_invoices.client_id = pd_clients.client_id
                            AND invoice_date_due <= DATE_SUB(NOW(),INTERVAL 31 DAY)
                )
        ) AS range_3', false);

        $this->db->select('
        (
            SELECT SUM(invoice_balance) FROM pd_invoice_amounts
                WHERE invoice_id IN
                (
                    SELECT invoice_id FROM pd_invoices
                        WHERE pd_invoices.client_id = pd_clients.client_id
                            AND invoice_date_due <= DATE_SUB(NOW(), INTERVAL 1 DAY)
                )
        ) AS total_balance', false);

        $this->db->having('range_1 >', 0);
        $this->db->or_having('range_2 >', 0);
        $this->db->or_having('range_3 >', 0);
        $this->db->or_having('total_balance >', 0);

        return $this->db->get('pd_clients')->result();
    }

    /**
     * @param null $from_date
     * @param null $to_date
     * @param null $minQuantity
     * @param null $maxQuantity
     * @param bool $taxChecked
     * @return mixed
     */
    public function sales_by_year(
        $from_date = null,
        $to_date = null,
        $minQuantity = null,
        $maxQuantity = null,
        $taxChecked = false
    ) {
        if ($minQuantity == "") {
            $minQuantity = 0;
        }

        if ($from_date == "") {
            $from_date = date("Y-m-d");
        } else {
            $from_date = date_to_mysql($from_date);
        }

        if ($to_date == "") {
            $to_date = date("Y-m-d");
        } else {
            $to_date = date_to_mysql($to_date);
        }

        $from_date_year = intval(substr($from_date, 0, 4));
        $to_date_year = intval(substr($to_date, 0, 4));

        $this->db->select('client_name as Name');
        $this->db->select('client_name');
        $this->db->select('client_surname');
        $this->db->select('CONCAT(client_name," ", client_surname) AS client_namesurname');

        if ($taxChecked == false) {

            if ($maxQuantity) {

                $this->db->select('client_id');
                $this->db->select('client_vat_id AS VAT_ID');
                $this->db->select('
                (
                    SELECT SUM(amounts.invoice_item_subtotal) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                        )
                ) AS total_payment', false);

                for ($index = $from_date_year; $index <= $to_date_year; $index++) {
                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-01-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-02-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-03-%\'
                                        )
                            )
                    ) AS payment_t1_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-04-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-05-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-06-%\'
                                        )
                            )
                    ) AS payment_t2_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-07-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-08-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-09-%\'
                                        )
                            )
                    ) AS payment_t3_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-10-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-11-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-12-%\'
                                        )
                            )
                    ) AS payment_t4_' . $index . '', false);

                }

                $this->db->where('
                (
                    SELECT SUM(amounts.invoice_item_subtotal) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . ' <= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . ' >= inv.invoice_date_created
                                    AND ' . $minQuantity . ' <=
                                    (
                                        SELECT SUM(amounts2.invoice_item_subtotal) FROM pd_invoice_amounts amounts2
                                            WHERE amounts2.invoice_id IN
                                            (
                                                SELECT inv2.invoice_id FROM pd_invoices inv2
                                                    WHERE inv2.client_id=pd_clients.client_id
                                                        AND ' . $this->db->escape($from_date) . ' <= inv2.invoice_date_created
                                                        AND ' . $this->db->escape($to_date) . ' >= inv2.invoice_date_created
                                            )
                                    ) AND ' . $maxQuantity . ' >=
                                    (
                                        SELECT SUM(amounts3.invoice_item_subtotal) FROM pd_invoice_amounts amounts3
                                            WHERE amounts3.invoice_id IN
                                            (
                                                SELECT inv3.invoice_id FROM pd_invoices inv3
                                                    WHERE inv3.client_id=pd_clients.client_id
                                                        AND ' . $this->db->escape($from_date) . ' <= inv3.invoice_date_created
                                                        AND ' . $this->db->escape($to_date) . ' >= inv3.invoice_date_created
                                            )
                                    )
                        )
                ) <>0');

            } else {

                $this->db->select('client_id');
                $this->db->select('client_vat_id AS VAT_ID');
                $this->db->select('client_name as Name');

                $this->db->select('
                (
                    SELECT SUM(amounts.invoice_item_subtotal) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                        )
                ) AS total_payment', false);

                for ($index = $from_date_year; $index <= $to_date_year; $index++) {

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-01-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-02-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-03-%\'
                                        )
                            )
                    ) AS payment_t1_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-04-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-05-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-06-%\'
                                        )
                            )
                    ) AS payment_t2_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-07-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-08-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-09-%\'
                                        )
                            )
                    ) AS payment_t3_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_item_subtotal) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-10-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-11-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-12-%\'
                                        )
                            )
                    ) AS payment_t4_' . $index . '', false);

                }

                $this->db->where('
                (
                    SELECT SUM(amounts.invoice_item_subtotal) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . ' <= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . ' >= inv.invoice_date_created
                                    AND ' . $minQuantity . ' <=
                                    (
                                        SELECT SUM(amounts2.invoice_item_subtotal) FROM pd_invoice_amounts amounts2
                                            WHERE amounts2.invoice_id IN
                                            (
                                                SELECT inv2.invoice_id FROM pd_invoices inv2
                                                WHERE inv2.client_id=pd_clients.client_id
                                                    AND ' . $this->db->escape($from_date) . ' <= inv2.invoice_date_created
                                                    AND ' . $this->db->escape($to_date) . ' >= inv2.invoice_date_created
                                            )
                                    )
                        )
                ) <>0');

            }

        } else if ($taxChecked == true) {

            if ($maxQuantity) {

                $this->db->select('client_id');
                $this->db->select('client_vat_id AS VAT_ID');
                $this->db->select('client_name as Name');

                $this->db->select('
                (
                    SELECT SUM(amounts.invoice_total) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                        )
                ) AS total_payment', false);

                for ($index = $from_date_year; $index <= $to_date_year; $index++) {

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-01-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-02-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-03-%\'
                                        )
                            )
                    ) AS payment_t1_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-04-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-05-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-06-%\'
                                        )
                            )
                    ) AS payment_t2_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-07-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-08-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-09-%\'
                                        )
                            )
                    ) AS payment_t3_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-10-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-11-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-12-%\'
                                        )
                            )
                    ) AS payment_t4_' . $index . '', false);

                }

                $this->db->where('
                (
                    SELECT SUM(amounts.invoice_total) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . ' <= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . ' >= inv.invoice_date_created
                                    AND ' . $minQuantity . ' <=
                                    (
                                        SELECT SUM(amounts2.invoice_total) FROM pd_invoice_amounts amounts2
                                            WHERE amounts2.invoice_id IN
                                            (
                                                SELECT inv2.invoice_id FROM pd_invoices inv2
                                                    WHERE inv2.client_id=pd_clients.client_id
                                                        AND ' . $this->db->escape($from_date) . ' <= inv2.invoice_date_created
                                                        AND ' . $this->db->escape($to_date) . ' >= inv2.invoice_date_created
                                            )
                                    ) AND ' . $maxQuantity . ' >=
                                    (
                                        SELECT SUM(amounts3.invoice_total) FROM pd_invoice_amounts amounts3
                                            WHERE amounts3.invoice_id IN
                                            (
                                                SELECT inv3.invoice_id FROM pd_invoices inv3
                                                    WHERE inv3.client_id=pd_clients.client_id
                                                        AND ' . $this->db->escape($from_date) . ' <= inv3.invoice_date_created
                                                        AND ' . $this->db->escape($to_date) . ' >= inv3.invoice_date_created
                                            )
                                    )
                        )
                ) <>0');

            } else {

                $this->db->select('client_id');
                $this->db->select('client_vat_id AS VAT_ID');
                $this->db->select('client_name as Name');

                $this->db->select('
                (
                    SELECT SUM(amounts.invoice_total) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                        )
                ) AS total_payment', false);

                for ($index = $from_date_year; $index <= $to_date_year; $index++) {

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-01-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-02-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-03-%\'
                                        )
                            )
                    ) AS payment_t1_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-04-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-05-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-06-%\'
                                        )
                            )
                    ) AS payment_t2_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-07-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-08-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-09-%\'
                                        )
                            )
                    ) AS payment_t3_' . $index . '', false);

                    $this->db->select('
                    (
                        SELECT SUM(invoice_total) FROM pd_invoice_amounts
                            WHERE invoice_id IN
                            (
                                SELECT invoice_id FROM pd_invoices inv
                                    WHERE inv.client_id=pd_clients.client_id
                                        AND ' . $this->db->escape($from_date) . '<= inv.invoice_date_created
                                        AND ' . $this->db->escape($to_date) . '>= inv.invoice_date_created
                                        AND
                                        (
                                            inv.invoice_date_created LIKE \'%' . $index . '-10-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-11-%\'
                                            OR inv.invoice_date_created LIKE \'%' . $index . '-12-%\'
                                        )
                            )
                    ) AS payment_t4_' . $index . '', false);

                }

                $this->db->where('
                (
                    SELECT SUM(amounts.invoice_total) FROM pd_invoice_amounts amounts
                        WHERE amounts.invoice_id IN
                        (
                            SELECT inv.invoice_id FROM pd_invoices inv
                                WHERE inv.client_id=pd_clients.client_id
                                    AND ' . $this->db->escape($from_date) . ' <= inv.invoice_date_created
                                    AND ' . $this->db->escape($to_date) . ' >= inv.invoice_date_created
                                    AND ' . $minQuantity . ' <=
                                    (
                                        SELECT SUM(amounts2.invoice_total) FROM pd_invoice_amounts amounts2
                                            WHERE amounts2.invoice_id IN
                                            (
                                                SELECT inv2.invoice_id FROM pd_invoices inv2
                                                    WHERE inv2.client_id=pd_clients.client_id
                                                        AND ' . $this->db->escape($from_date) . ' <= inv2.invoice_date_created
                                                        AND ' . $this->db->escape($to_date) . ' >= inv2.invoice_date_created
                                            )
                                    )
                        )
                ) <>0');

            }

        }

        $this->db->order_by('client_namesurname');
        return $this->db->get('pd_clients')->result();
    }

}
