<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Versions
 */
class Versions extends Admin_Controller
{
    /**
     * Versions constructor.
     */
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);
    

        $this->load->model('mdl_versions');
    }

    /**
     * @param int $page
     */
    public function index($page = 0)
    {
        $this->mdl_versions->paginate(site_url('versions/index'), $page);
        $versions = $this->mdl_versions->result();

        $this->layout->set('versions', $versions);
        $this->layout->buffer('content', 'settings/versions');
        $this->layout->render();
    }

}
