# Module "units"
CREATE TABLE IF NOT EXISTS `pd_units` (
  `unit_id`        INT(11) NOT NULL AUTO_INCREMENT,
  `unit_name`      VARCHAR(50)      DEFAULT NULL,
  `unit_name_plrl` VARCHAR(50)      DEFAULT NULL,
  PRIMARY KEY (`unit_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

ALTER TABLE pd_products
  ADD COLUMN IF NOT EXISTS unit_id INT(11);

ALTER TABLE pd_quote_items
  ADD COLUMN IF NOT EXISTS item_product_unit VARCHAR(50) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS item_product_unit_id INT(11);

ALTER TABLE pd_invoice_items
  ADD COLUMN IF NOT EXISTS item_product_unit VARCHAR(50) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS item_product_unit_id INT(11);

# Custom Field Enhancements
CREATE TABLE IF NOT EXISTS `pd_custom_values` (
  `custom_values_id`    INT(11) NOT NULL AUTO_INCREMENT,
  `custom_values_field` INT(11) NOT NULL,
  `custom_values_value` TEXT    NOT NULL,
  PRIMARY KEY (`custom_values_id`)
)
  ENGINE = MyISAM
  DEFAULT CHARSET = utf8;

ALTER TABLE `pd_custom_fields`
  ADD COLUMN IF NOT EXISTS`custom_field_type` VARCHAR(255) DEFAULT 'TEXT' NOT NULL
  AFTER `custom_field_label`;


ALTER TABLE `pd_clients`
  ADD COLUMN IF NOT EXISTS client_surname VARCHAR(255) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS client_avs VARCHAR(16) DEFAULT NULL;

ALTER TABLE `pd_clients`
  ADD COLUMN IF NOT EXISTS client_insurednumber VARCHAR(30) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS client_veka VARCHAR(30) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS client_birthdate DATE DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS client_gender INT(1) DEFAULT 0;

ALTER TABLE `pd_invoice_items`
  ADD COLUMN IF NOT EXISTS item_date DATE;

INSERT INTO `pd_settings` (setting_key, setting_value)
VALUES
  ('sumex', '0'),
  ('sumex_sliptype', '1'),
  ('sumex_canton', '0');

ALTER TABLE `pd_users`
  ADD COLUMN IF NOT EXISTS user_subscribernumber VARCHAR(40) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS user_iban VARCHAR(34) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS user_gln BIGINT(13) DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS user_rcc VARCHAR(7) DEFAULT NULL;

ALTER TABLE `pd_products`
  ADD COLUMN IF NOT EXISTS product_tariff INT(11) DEFAULT NULL;

# End Sumex Changes

# Delete and re-add the pd_sessions table for CI 3
CREATE TABLE IF NOT EXISTS `pd_sessions` (
  `id`         VARCHAR(128)               NOT NULL,
  `ip_address` VARCHAR(45)                NOT NULL,
  `timestamp`  INT(10) UNSIGNED DEFAULT 0 NOT NULL,
  `data`       BLOB                       NOT NULL,
  KEY `pd_sessions_timestamp` (`timestamp`)
);

# IP-491 - Localization per client and user
ALTER TABLE `pd_users`
  ADD COLUMN IF NOT EXISTS `user_language` VARCHAR(255) DEFAULT 'system'
  AFTER `user_date_modified`;

ALTER TABLE `pd_clients`
  ADD COLUMN IF NOT EXISTS `client_language` VARCHAR(255) DEFAULT 'system'
  AFTER `client_tax_code`;

# Insert default theme into database (IP-338)
INSERT INTO `pd_settings` (setting_key, setting_value)
VALUES ('system_theme', 'invoiceplane');

# Feature IP-162
# Allow invoice item to refer to a table `products` or to table `tasks`
ALTER TABLE `pd_invoice_items`
  ADD COLUMN IF NOT EXISTS `item_task_id` INT(11) DEFAULT NULL
  AFTER `item_date_added`;

# Add default hourly rate for tasks
INSERT INTO `pd_settings` (`setting_key`, `setting_value`)
VALUES ('default_hourly_rate', '0.00');
INSERT INTO `pd_settings` (`setting_key`, `setting_value`)
VALUES ('projects_enabled', '1');

# Add tax rate to tasks
ALTER TABLE `pd_tasks`
  ADD COLUMN IF NOT EXISTS `tax_rate_id` INT(11) NOT NULL
  AFTER `task_status`;

# Switch to row based custom fields (instead of columns)
# (See Mdl_setup for the migration script)

# Custom Fields
ALTER TABLE pd_custom_fields
  MODIFY custom_field_table VARCHAR(50),
  MODIFY custom_field_label VARCHAR(50),
  ADD COLUMN IF NOT EXISTS custom_field_location INT(11) DEFAULT 0,
  ADD COLUMN IF NOT EXISTS custom_field_order INT(11) DEFAULT 999,
  ADD CONSTRAINT UNIQUE (custom_field_table, custom_field_label);

  
