<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Families
 */
class Vendors extends Admin_Controller
{
    /**
     * Families constructor.
     */
    public function __construct()
    {
        $this->load->library('session');

        $userTypeId = $this->session->userdata('user_type');
        parent::__construct($userTypeId);


        $this->load->model('mdl_vendors');
    }

    /**
     * @param int $page
     */
    public function index($page = 0)
    {
        $this->mdl_vendors->paginate(site_url('vendors/index'), $page);
        $vendors = $this->mdl_vendors->result();

        $this->layout->set('vendors', $vendors);
        $this->layout->buffer('content', 'vendors/index');
        $this->layout->render();
    }

    /**
     * @param null $id
     */
    public function form($id = null)
    {
        if ($this->input->post('btn_cancel')) {
            redirect('vendors');
        }

        if ($this->input->post('is_update') == 0 && $this->input->post('vendor_name') != '') {
            $check = $this->db->get_where('pd_vendors', array('vendor_name' => $this->input->post('vendor_name')))->result();

            if (!empty($check)) {
                $this->session->set_flashdata('alert_error', trans('vendor_already_exists'));
                redirect('vendors/form');
            }
        }

        if ($this->mdl_vendors->run_validation()) {
            $this->mdl_vendors->save($id);
            redirect('vendors');
        }

        if ($id and !$this->input->post('btn_submit')) {
            if (!$this->mdl_vendors->prep_form($id)) {
                show_404();
            }

            $this->mdl_vendors->set_form_value('is_update', true);
        }

        $this->layout->buffer('content', 'vendors/form');
        $this->layout->render();
    }


    /**
     * @param $id
     */
    public function delete($id)
    {
        $this->mdl_vendors->delete($id);
        redirect('vendors');
    }

}
