<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_Families
 */
class Mdl_Vendors extends Response_Model
{
    public $table = 'pd_vendors';
    public $primary_key = 'pd_vendors.vendor_id';

    public function default_select()
    {
        $this->db->select('SQL_CALC_FOUND_ROWS *', false);
    }

    public function default_order_by()
    {
        $this->db->order_by('pd_vendors.vendor_name');
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(
            'vendor_name' => array(
                'field' => 'vendor_name',
                'label' => trans('vendor_name'),
                'rules' => 'required'
            )
        );
    }

}
