<!DOCTYPE html>
<html lang="<?php _trans('cldr'); ?>">
<head>
    <meta charset="utf-8">
    <title><?php _trans('Income and Payment Statement'); ?></title>
    <link rel="stylesheet"
          href="<?php echo base_url(); ?>assets/<?php echo get_setting('system_theme', 'invoiceplane'); ?>/css/templates.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/core/css/custom-pdf.css">
</head>
<body>

<?php foreach($company_info as $comp_info){ ?>

<div style="text-align: right;">

   <b> <?php echo $comp_info->user_company ?></b><br><br>
    <?php echo $comp_info->user_address_1 ?><br><br>
    <?php echo 'TPIN: '. $comp_info->user_tax_code ?><br><br>
    <?php echo 'VAT REG: '.$comp_info->user_vat_id ?>


</div>
<?php }?>

<div style="text-align: center;">
<h2 >
    <?php echo trans('Income and Payment Statement'); ?><br/></h2>
    <small><?php echo 'Period: '.$from_date . ' - ' . $to_date ?></small>

</div>
<main>

<?php
$taxes_paid = 0;
$expense_total = 0;
$income_total = 0;
$taxes = '';
$profit = 0;
$loss = 0;

?>



    <table class="item-table">
    <tr>
            <th><h1 class="invoice-title text-green"><?php echo trans('Income')  ?></h1></th>

        </tr>
    <?php foreach($incomes as $income) {
        $income_total += $income->invoice_paid;
        $taxes = $income->invoice_item_tax_total + $income->invoice_tax_total;
        $taxes_paid += $taxes;
        // $taxes .=$income->tax_rate_name.' ,';
        // if ($index < count($incomes) - 1) {
        //     $taxes .= ', ';
        // }
    }?>

        <tbody>
            <tr>
                <td><strong><?php _trans('Turnover'); ?></strong></td>
                <td class="text-right">
                <?php echo format_currency($income_total); ?>
            </td>
            </tr>
        </tbody>

<tr>
    <th></th>
</tr>

<tr>
            <td><h1 class="invoice-title text-green"><?php echo trans('Expenses')  ?></h1></td></tr>


        <?php foreach($expenses as $expense){

            $expense_total+=$expense->item_total;?>



            <thead>
        <tr>
            <th  ></th>
            <th  class="text-right"></th>


        </tr>
        <tr>

        </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php _htmlsc($expense->Category); ?></t>
                <td class="text-right">
                <?php echo format_currency($expense->item_total); ?>
            </td>
            </tr>

        </tbody>


            <?php } ?>
            <tr>
                <td></td>
        </tr>


<tbody class="invoice-sums">

<tr>
                <td colspan="" class="text-right">
                    <?php _trans('Gross Income'); ?>
                </td>
                <td class="text-right">
                    <?php echo format_currency($income_total); ?>
                </td>
            </tr>
            <tr>
                <td colspan="" class="text-right">
                    <?php _trans('Total Expense'); ?>
                </td>
                <td class="text-right">
                    <?php echo format_currency($expense_total); ?>
                </td>
            </tr>
            <tr>
                <td colspan="" class="text-right">
                    <?php _trans('Total Tax Amount'); ?>
                </td>
                <td class="text-right">
                    <?php echo format_currency($taxes_paid); ?>
                </td>
            </tr>
            <tr>
                <td colspan="" class="text-right">
                    <?php _trans('Earnings Before Tax'); ?>
                </td>
                <td class="text-right">
                    <?php echo format_currency($income_total - $expense_total); ?>
                </td>
            </tr>


            <tr><td  class="text-right">
                <?php _trans('Profit'); ?>
            </td>
            <?php if($income_total - $expense_total - $taxes_paid >= 0){?>
                <td class="text-right">
                    <?php echo format_currency($income_total - $expense_total - $taxes_paid); ?>
                </td>
                <?php }else{?>
                    <td class="text-right">
                    <?php echo format_currency(0); ?>
                </td>

                    <?php } ?>
            </tr>

            <tr><td  class="text-right">
                <?php _trans('Loss'); ?>
            </td>
            <?php if($income_total - $expense_total - $taxes_paid <= 0){?>
                <td class="text-right">
                    <?php echo format_currency($income_total - $expense_total - $taxes_paid); ?>
                </td>
                <?php }else{?>
                    <td class="text-right">
                    <?php echo format_currency(0); ?>
                </td>

                    <?php } ?>
            </tr>



        </tbody>

    </table>


</main>

<watermarktext content="<?php _trans('Profit And Loss'); ?>" alpha="0.3" />



</body>
</html>
